
# coding: utf-8

# In[132]:


import requests
import csv
import bs4


# In[133]:


api_url = 'https://earthquake.usgs.gov/fdsnws/event/1/'
api_method = 'query?'
api_method_2 = 'count?'
api_format = 'format=geojson'
api_starttime = '1968-02-27'
api_endtime = '2018-02-27'
api_minlatitude = '10'
api_minlongitude = '92'
api_maxlatitude = '23.26'
api_maxlongitude = '140'
api_minmagnitude = '1'
api_maxmagnitude = '10'


# In[134]:


url = api_url + api_method + api_format + '&' + 'starttime=' + api_starttime + '&' + 'endtime=' + api_endtime + '&' + 'minlatitude=' + api_minlatitude + '&' + 'maxlatitude=' + api_maxlatitude + '&' +'minlongitude=' + api_minlongitude + '&' + 'maxlongitude=' + api_maxlongitude + '&' + 'minmagnitude=' + api_minmagnitude + '&' + 'maxmagnitude=' + api_maxmagnitude


# In[136]:


url_2 = api_url + api_method_2 + api_format + '&' + 'starttime=' + api_starttime + '&' + 'endtime=' + api_endtime + '&' + 'minlatitude=' + api_minlatitude + '&' + 'maxlatitude=' + api_maxlatitude +  '&' +'minlongitude=' + api_minlongitude + '&' + 'maxlongitude=' + api_maxlongitude + '&' + 'minmagnitude=' + api_minmagnitude + '&' + 'maxmagnitude=' + api_maxmagnitude


# In[138]:


response = requests.get(url)
response_2 = requests.get(url_2)


# In[139]:


data = response.json()
count = response_2.json()


# In[140]:


data


# In[141]:


count


# In[142]:


place = []
mag = []
time = []
for i in range(0,len(data['features'])):
    mag.append(data['features'][i]['properties']['mag'])
    place.append(data['features'][i]['properties']['place'])
    time.append(data['features'][i]['properties']['time'])


# In[143]:


new_time = []
import datetime
for i in range(0, len(time)):
    dt = datetime.datetime.fromtimestamp(time[i]/1000.0)
    dt.year
    dt.month
    dt.day
    new_time.append(dt)


# In[144]:


new_time


# In[145]:


with open('1_10.csv','w',newline='') as f:
    writer = csv.writer(f)
    header = ['place', 'mag', 'time']
    writer.writerow(header)
    writer.writerows(zip(place,mag,new_time))

